/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeStorageMonitor;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.config.FilterConfig;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileStorageMonitor
extends TileNode<NetworkNodeStorageMonitor> {
    public static final TileDataParameter<Integer, TileStorageMonitor> COMPARE = FilterConfig.createCompareParameter();
    private static final String NBT_STACK = "Stack";
    private static final String NBT_AMOUNT = "Amount";
    private long amount;
    @Nullable
    private ItemStack itemStack;

    public TileStorageMonitor() {
        this.dataManager.addWatchedParameter(COMPARE);
    }

    @Override
    public NetworkNodeStorageMonitor createNode(World world, BlockPos pos) {
        return new NetworkNodeStorageMonitor(world, pos);
    }

    @Override
    public String getNodeId() {
        return "storage_monitor";
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        ItemStack stack = ((NetworkNodeStorageMonitor)this.getNode()).getConfig().getItemHandler().getStackInSlot(0);
        if (!stack.func_190926_b()) {
            tag.func_74782_a(NBT_STACK, (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        tag.func_74772_a(NBT_AMOUNT, ((NetworkNodeStorageMonitor)this.getNode()).getAmount());
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        super.readUpdate(tag);
        this.itemStack = tag.func_74764_b(NBT_STACK) ? new ItemStack(tag.func_74775_l(NBT_STACK)) : null;
        this.amount = tag.func_74763_f(NBT_AMOUNT);
    }

    @Override
    protected boolean canCauseRenderUpdate(NBTTagCompound tag) {
        EnumFacing receivedDirection = EnumFacing.func_82600_a((int)tag.func_74762_e("Direction"));
        boolean receivedActive = tag.func_74767_n("Active");
        return receivedDirection != this.getDirection() || receivedActive != ((NetworkNodeStorageMonitor)this.getNode()).isActive();
    }

    public long getAmount() {
        return this.amount;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

